<?php

namespace App\Models;

use Illuminate\Contracts\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Rolepengeluaran extends Model
{
    use HasFactory;
    protected $fillable = [
        'supplier_id',
        'kd_pengeluaran',
        'total',
        'sts_role',
    ];

    public function supplier(): BelongsTo
    {
        return $this->belongsTo(Supplier::class);
    }

    public function pengeluaran(): HasOne
    {
        return $this->hasOne(Pengeluaran::class);
    }

    public function scopePencarian(Builder $query): void
    {
        $query->where('kd_pengeluaran', 'like', '%' .  request('cari') . '%')
            ->whereHas('supplier', function ($query) {
                $query->where('nm_supplier', 'like', '%' .  request('cari') . '%');
            });
    }
}
